set Release(unbind.tcl) {$Header: /home/cvs/tktest/unbind.tcl,v 1.2 2004/03/13 17:45:30 clif Exp $}
#
# unbind.tcl
#     This is a program that tries to undo the binding done when you
#      connect to a program.  IT DOES NOT WORK YET.
#

###################################################################
# This file is sourced by the application we are recording.
###################################################################
#
# Rename all the commands back.
#
rename bind__rd        bind
rename bindtags__rd    bindtags
rename button__rd      button
rename canvas__rd      canvas
rename checkbutton__rd checkbutton
rename destroy__rd     destroy
rename entry__rd       entry
rename frame__rd       frame
rename label__rd       label
rename listbox__rd     listbox
rename menubutton__rd  menubutton
rename menu__rd        menu
rename message__rd     message
rename radiobutton__rd radiobutton
rename scale__rd       scale
rename scrollbar__rd   scrollbar
rename text__rd        text
rename toplevel__rd    toplevel
###################################################################
# RebindWidgetAndChildren: unbind one widget and then all its children
###################################################################
proc RebindWidgetAndChildren {w} {
    global db__rd
    RebindOneWidget $w
    foreach child [winfo children $w] {
        RebindWidgetAndChildren $child
    }
}
###################################################################
# RebindOneWidget: 
###################################################################
proc RebindOneWidget {w} {
    global db__rd
    HandleSpecialCases $w
    #
    # find all tags that must be rebound for this widget
    #
    foreach tag [bindtags $w] {
        foreach event [bind $tag] {
            bind $tag $event $db__rd(Bind,$tag,$event)
            RemoteMsgToUser "Unbinding $tag $event"
        }
    }
}
###################################################################
# HandleSpecialCases: handle the widgets that need special processing.
###################################################################
proc HandleSpecialCases {w} {
    global db__rd
    switch -- [winfo class $w] \
        Text {
            foreach tag [$w tag names] {
                foreach event [$w tag bind $tag] {
                    set longTag [format {Text,%s,%s} $w $tag]
                    $w tag bind $event $db__rd(Bind,$longTag,$event)
                    RemoteMsgToUser "Unbinding Text tag $tag ($event)"
                }
            }
        } \
        Canvas {
            RemoteMsgToUser "Unbinding \"Canvas\""
            # go through each item on the canvas
            set tags {}
            foreach item [$w find all] {
                foreach tag [$w gettags $item] {
                    if {[lsearch $tags $tag] < 0} {
                        lappend tags $tag
                    }
                }
                # go through each event bound for that item
                foreach event [$w bind $item] {
                    set longItem [format {CItem,%s,%s} $w $item]
                    $w bind $item $event $db__rd(Bind,$longItem,$event)
                    RemoteMsgToUser "Unbinding Canvas item $item ($event)"
                }
            }
            foreach tag [RemoveDuplicates $tags] {
                foreach event [$w bind $tag] {
                    set longTag [format {CTag,%s,%s} $w $tag]
                    $w bind $tag $event db__rd(Bind,$longTag,$event)
                    RemoteMsgToUser "Rebinding Canvas tag $tag ($event)"
                }
            }
        }
}
###################################################################
# RemoveDuplicates: converts a list with duplicates to a list without
#   duplicates.  It keeps the last of duplicate items.
###################################################################
proc RemoveDuplicates {bag} {
    set nodups {}
    set index 1
    foreach item $bag {
        set nextone [lsearch -exact [lrange $bag $index end] $item]
        if {$nextone < 0} {
            lappend nodups $item
        }
        incr index
    }
    return $nodups
}
#
# Undefine the commands we defined in rebind.tcl.
#
foreach pr {
    RebindWidgetAndChildren
    RebindOneWidget
    RebindOneEvent
    HandleSpecialCases
    GetPercentFields
    RemoveDuplicates
    cb__rd
    ReplayAction
    DoActionAndReply
    DoAction
    SubInAction
    SubForCurrent
    lookup
    RemoteMsgToUser} {
        if {[info procs $pr] != ""} {
            rename $pr ""
        }
}
