set Release(help.tcl) {$Header: /home/cvs/tktest/help.tcl,v 1.5 2004/09/02 18:43:57 clif Exp $}

# ShowAbout: create the about box

proc ShowAbout {} {
  global Release

  catch {destroy .about}
  toplevel .about
   text .about.t -width 60 -height 15 -yscrollcommand {.about.sb set}
  scrollbar .about.sb -orient vertical -command {.about.t yview}
  button .about.b -text "Done" -command {destroy .about}
  grid .about.t -row 0 -column 0
  grid .about.sb -row 0 -column 1 -sticky ns
  grid .about.b -row 1 -column 0
  
  .about.t insert end {
     TkReplay - record and replay for Tcl/Tk
     
     Initially developed by
        Charlie Crowley
        Computer Science Department
        Univ. Of New Mexico
        crowley@cs.unm.edu
        http://www.cs.unm.edu/~crowley/

     Updated for Tk 8.4 Extended by
        Clif Flynt
	Noumena Corporation
	http://www.noucorp.com
	
     This release consists of these file versions:
}
    foreach n [lsort [array names Release]] {
      set l [split $Release($n)]
      set fn [file tail [lindex $l 1]]
      regsub {,v$} $fn {} fn
      .about.t insert end [format "%-16s: %s\n" $fn [lindex $l 2]]
    }
}
#
# RecordMessage: record a message in the transcript window
#
proc RecordMessage {msg} {
    .messageWindow.text insert end $msg
    .messageWindow.text insert end \n
    .messageWindow.text yview -pickplace end
}
#
# MakeMessageWindow: create a window to record messages
#
proc MakeMessageWindow {} {
    set w .messageWindow
    toplevel $w
    wm geometry $w "+0+260"
    wm withdraw $w
    button $w.done -text "Hide this window" -command "wm withdraw $w"
    pack $w.done -side bottom
    scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
        -command "$w.text yview"
    pack $w.yscroll -side right -fill y
    text $w.text -width 50 -height 16 -relief sunken -bd 2 \
        -yscrollcommand "$w.yscroll set"
    pack $w.text -side left -fill both -expand yes
    $w.text insert end "*** Transcript of all message ***\n"
}
#
# ShowHelp: display a text window on the help text
#
proc ShowHelp {} {
    global ReplayData

    if [catch "open $ReplayData(HomeDirectory)/HelpFile" fid] {
        error \
            "Could not open help file \"$ReplayData(HomeDirectory)/HelpFile\""
    }
    set HelpText [read $fid]
    close $fid

    set w .replay.helpWindow
    if [winfo exists $w] {
        wm deiconify $w
    } else {
        toplevel $w
        wm minsize $w 10 10
        wm geometry $w "+0+0"
        button $w.done -text Done -command "wm withdraw $w"
        pack $w.done -side bottom
        scrollbar $w.yscroll -orient vertical -relief sunken -bd 2 \
            -command "$w.text yview"
        pack $w.yscroll -side right -fill y
        text $w.text -width 80 -height 30 -relief sunken -bd 2 \
            -yscrollcommand "$w.yscroll set"
        pack $w.text -side left -fill both -expand yes
        $w.text insert end $HelpText
    }
}
